<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 * @package   jchoptimize/wordpress-platform
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2020 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 * If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

namespace JchOptimize\Helper\Renderer;

use JchOptimize\Helper\TabContent;

class Section
{
	public static function miscellaneousSection()
	{
		echo TabContent::addTab( 'general-tab', true );

		$title = __( 'General', 'jch-optimize' );

		echo TabContent::addSection( $title );
	}

	public static function excludeMenuItemsSection()
	{
		$title       = __( 'Exclude Menu Urls', 'jch-optimize' );
		$description = __( 'Enter any part of a url to exclude that page from optimization. You will need to add these urls to the list manually by typing the url in the textbox and click the \'Add item\' button.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function combineCssJsSection()
	{
		$title       = __( 'Combine CSS/Js', 'jch-optimize' );
		$description = __( 'These settings affect the combined CSS and javascript files generated by the plugin.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function combineCssJsAutoSection()
	{
		$title       = __( 'Combine Files Automatic Settings', 'jch-optimize' );
		$description = __( 'These settings for the combined files are configured by the Automatic settings on the Dashboard tab. You don\'t need to configure them yourself.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function cssAutoSettingsSection()
	{
		echo TabContent::addTab( 'css-tab' );

		$title       = __( 'CSS Automatic Settings', 'jch-optimize' );
		$description = __( 'These settings are configured by the Automatic settings on the Control Panel tab. You don\'t need to configure them yourself.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function excludeCssSection()
	{
		$title       = __( 'Exclude CSS Files', 'jch-optimize' );
		$description = __( 'Exclude individual CSS files or files from select plugins. To add an item to the drop-down list manually, type any part of the url in the textbox then click the \'Add item\' button. CSS files are always excluded while preserving execution order. The combined file will split itself around excluded files to preserve the original order of files on the page. ' );

		echo TabContent::addSection( $title, $description );
	}

	public static function removeCssSection()
	{
		$title       = __( 'Remove CSS Files', 'jch-optimize' );
		$description = __( 'You can remove and prevent css files from loading on the page if they\'re not being used at all to speed up page load and rendering. Please be sure these files are not being used anywhere on the site to prevent breaking your pages.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function optimizeGoogleFontsSection()
	{
		$title       = __( 'Optimize Google Fonts', 'jch-optimize' );
		$description = __( 'Optimize the loading of Google fonts to reduce Largest Contentful Paint on Google PageSpeed insights.' );

		echo TabContent::addSection( $title, $description );
	}

	public static function optimizeCssDeliverySection()
	{
		$title       = __( 'Optimize CSS Delivery', 'jch-optimize' );
		$description = __( 'The plugin will attempt to extract the critical CSS that is required to format the page above the fold and put this in a &lt;style&gt; element inside the &lt;head&gt; section of the HTML to prevent \'render-blocking\'. The combined CSS will then be loaded asynchronously. Select the number of HTML elements from the top of the page that you want the plugin to find the critical CSS for. The smaller the number, the smaller the size of the critical CSS but you might see some jumping of the page if the number is too small.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function javascriptAutomaticSettingsSection()
	{
		echo TabContent::addTab( 'javascript-tab' );

		$title       = __( 'Javascript Automatic Settings', 'jch-optimize' );
		$description = __( 'These settings are configured by the Automatic settings on the Control Panel tab. You don\'t need to configure them yourself', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function excludePeoSection()
	{
		$title       = __( 'Exclude Files While Preserving Execution Order', 'jch-optimize' );
		$description = __( 'Exclude individual javascript files or files from selected extensions. Files selected in this section will be excluded while preserving execution order on the page by splitting the combined files around excluded files. This ensures no dependency between files are broken and break the page.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function excludeIeoSection()
	{
		$title       = __( 'Exclude File Ignoring Execution Order', 'jch-optimize' );
		$description = __( 'Only use these settings if you\'re sure that the files/scripts you are excluding does not have any dependencies on any other files/scripts that are combined. If you are not sure then use the above section to exclude your files to avoid breaking your page.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function dontMoveSection()
	{
		$title       = __( 'Don\'t Move These Files To Bottom Of Page When Excluded', 'jch-optimize' );
		$description = __( 'By default, the plugin will move all excluded and combined javascript files to the bottom of the page when using the Premium or Optimum setting. If there\'s a javascript file or script that is excluded that you DON\'T want moved to the bottom of the page, enter them here in these settings. These files/scripts must be excluded above for these settings to take effect.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function removeJsSection()
	{
		$title       = __( 'Remove Javascript Files', 'jch-optimize' );
		$description = __( 'You can remove and prevent javascript files from loading on the page if they\'re not being used at all. This helps to speed up page download and rendering. Please be sure these files are not being used anywhere on the site to prevent breaking your pages.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function pageCacheSection()
	{
		echo TabContent::addTab( 'page-cache-tab' );

		$title       = __( 'Page Cache', 'jch-optimize' );
		$description = __( 'The HTML source of the page will be cached to significantly speed up page loads. Deactivate caching while configuring the plugin and be sure to flush cache after making changes to the site.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function addImageAttributesSection()
	{
		echo TabContent::addTab( 'media-tab' );

		$title       = __( 'Add Image Attributes', 'jch-optimize' );
		$description = __( 'When enabled, the plugin will add missing \'width\' and \'height\' attributes to &lt;img/&gt; elements. PLEASE NOTE: This works best when the images are scaled to the size they are shown onscreen. If images appear the wrong size, try rescaling the images correctly or disable this option.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function spriteGeneratorSection()
	{
		$title       = __( 'Sprite Generator', 'jch-optimize' );
		$description = __( 'The plugin will combine selected background images into one image called a sprite to reduce http requests. Combine CSS must be enabled for the Sprite Generator to work.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function lazyLoadSection()
	{
		$title       = __( 'Lazy-Load Images' );
		$description = __( 'Enable to delay the loading of iframes, images and responsive images until they are scrolled into view. This further speeds up the loading of the page and reduces http requests.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function http2PushSection()
	{
		echo TabContent::addTab( 'http2-tab' );

		$title       = __( 'Http/2 Push', 'jch-optimize' );
		$description = __( 'Plugin will send appropriate headers to your server to push resource files before the browser requests them. Please note this only works if http/2 is enabled on the server', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function cdnSection()
	{
		echo TabContent::addTab( 'cdn-tab' );

		$title       = __( 'CDN', 'jch-optimize' );
		$description = __( 'Enter your CDN or cookieless domain here. The plugin will load all static files including background images, combined javascript and CSS files, and generated sprite from this domain. This requires that this domain is already set up and points to your site root.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function globalSection()
	{
		echo TabContent::addTab( 'optimize-image-tab' );

		$title       = __( 'Global Options', 'jch-optimize' );
		$description = __( 'Use our API to optimize the images on your server. You can either let the plugin find the images on your page to optimize or manually select them in the file tree explorer. Be sure to save your \'Download ID\' in the plugin before trying to optimize images as that will authenticate you to access the API. These settings apply to both methods.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function autoApiSection()
	{
		$title       = __( 'Optimize Images By Pages' );
		$description = __( 'The plugin will scan the pages of your website for you to find the images to optimize. (Currently only the Main Menu). You don\'t need to select them beforehand.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function manualApiSection()
	{
		$title       = __( 'Optimize Images By Folders' );
		$description = __( 'Use the file tree to select the subfolders and files you want to optimize. Files will be optimized in subfolders recursively. If you want to rescale your images while optimizing, enter the new width and height in the respective columns beside each image on the right hand side.', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	public static function reduceDomSection()
	{
		echo TabContent::addTab( 'miscellaneous-tab' );

		$title       = __( 'Reduce DOM', 'jch-optimize' );
		$description = __( 'HTML5 sectioning related elements such as header, footer, section, aside, and nav that fall below the fold will be commented out if the number of DOM elements exceed 600. These sections will be inserted back into the DOM using javascript after the page has been loaded. <span class="alert alert-warning" style="padding: 1px 3px;"> Warning: Use with care. Can interfere with sections that use javascript to render.</span>', 'jch-optimize' );

		echo TabContent::addSection( $title, $description );
	}

	private static function new()
	{
		return <<<HTML
<span class="badge bg-danger">New!</span>
HTML;
	}
}